/*
 * Decompiled with CFR 0.152.
 */
package al132.alib.client;

import al132.alib.client.CapabilityDisplayWrapper;
import al132.alib.container.ABaseContainer;
import al132.alib.tiles.ABaseTile;
import java.text.NumberFormat;
import java.util.Locale;
import net.minecraft.client.resources.language.I18n;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class CapabilityFluidDisplayWrapper
extends CapabilityDisplayWrapper {
    public static NumberFormat numFormat = NumberFormat.getInstance(Locale.US);
    private ABaseContainer container = null;
    private ABaseTile tile = null;

    public CapabilityFluidDisplayWrapper(int x, int y, int width, int height, ABaseContainer container) {
        super(x, y, width, height);
        this.container = container;
    }

    public CapabilityFluidDisplayWrapper(int x, int y, int width, int height, ABaseTile tile) {
        super(x, y, width, height);
        this.tile = tile;
    }

    public IFluidHandler getHandler() {
        if (this.container != null) {
            return (IFluidHandler)this.container.tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).orElse(null);
        }
        return (IFluidHandler)this.tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).orElse(null);
    }

    @Override
    public int getStored() {
        return this.getHandler().getFluidInTank(0).getAmount();
    }

    @Override
    public int getCapacity() {
        return this.getHandler().getTankCapacity(0);
    }

    public String toString() {
        FluidStack stack = this.getHandler().getFluidInTank(0);
        String fluidName = "";
        String stored = numFormat.format(this.getStored());
        String capacity = numFormat.format(this.getCapacity());
        if (!stack.isEmpty() && stack.getAmount() > 0) {
            fluidName = I18n.m_118938_((String)stack.getFluid().getAttributes().getTranslationKey(), (Object[])new Object[0]);
        }
        String out = stored + "/" + capacity + " mb " + fluidName;
        return out;
    }
}

